import { AppDefaultViewLayout } from "../app-default-view-layout/app-default-view-layout";
import { Prop, Component } from 'vue-property-decorator';
import './app-default-pickupview3-layout.less';
import { IPSDEPickupViewPanel } from "@ibiz/dynamic-model-api";

@Component({})
export class AppDefaultPickupView3Layout extends AppDefaultViewLayout {

    /**
     * 视图引擎初始化
     * 
     * @memberof AppDefaultPickupView3Layout
     */
    public engineInit() {
        if (this.Environment && this.Environment.isPreviewMode) {
            return;
        }
        let pickupViewPanelModels: any[] = [];
        const controls: any[] = this.containerModel.getPSControls() || [];
        controls.forEach((control: any) => {
            if (control.controlType == 'PICKUPVIEWPANEL') {
                pickupViewPanelModels.push(control as IPSDEPickupViewPanel);
            }
        })
        this.engine.init({
            view: this,
            pickupViewPanelModels: pickupViewPanelModels,
            keyPSDEField: this.appDeCodeName.toLowerCase(),
            majorPSDEField: this.appDeMajorFieldName.toLowerCase(),
        });
    }

    /**
     * 绘制内容
     * 
     * @memberof AppDefaultPickupView3Layout
     */
    public renderContent() {
        let cardClass = {
            'view-card': true,
            'view-no-caption': true,
            'view-no-toolbar': true,
        };
        return (
            <card class={cardClass} disHover={true} bordered={false}>
                {this.$slots.topMessage}
                <div class='content-container pickup-view'>
                    {this.$slots.default}
                </div>
                {this.$slots.bottomMessage}
            </card>
        );
    }
}