import { MDViewController } from '@ibiz-template/controller';
import { defineComponent, PropType } from 'vue';

export const MDViewBase = defineComponent({
  props: {
    controller: {
      type: Object as PropType<MDViewController>,
      required: true,
    },
  },
  setup() {
    return {};
  },
  render() {
    const c = this.controller;

    // 外面的插槽同样传给view-layout
    const inheritSlots: IData = {};
    Object.keys(this.$scopedSlots).forEach(key => {
      inheritSlots[key] = (arg: IData) => this.$scopedSlots[key]!(arg);
    });

    return (
      <view-base
        controller={c}
        scopedSlots={{
          quickSearch: () => {
            if (c.complete && c.model.source.enableQuickSearch) {
              return (
                <quick-search
                  value={c.query}
                  viewMode={c.modal.mode}
                  placeholder={c.model.placeholder}
                  on-update={(val: string) => {
                    c.query = val;
                  }}
                  on-search={() => c.onSearch()}
                ></quick-search>
              );
            }
          },
          searchForm: () => {
            if (c.complete && c.model.searchForm && c.showSearchForm) {
              return (
                <search-form-control
                  modelData={c.model.searchForm}
                  context={c.context}
                  params={c.params}
                  on-neuronInit={c.nerve.onNeuronInit(
                    c.model.searchForm.source.name,
                  )}
                ></search-form-control>
              );
            }
          },
          ...inheritSlots,
        }}
      />
    );
  },
});
