import { IModalData } from '@ibiz-template/runtime';
import Vue from 'vue';
import { AppModalOptions } from '@/interface';
import { AppModalComponent } from './app-modal-component';
import { piniaInstance } from '@/store';

export class AppModal {
  /**
   * 打开模态
   *
   * @author lxm
   * @date 2022-09-09 17:09:55
   * @static
   * @param {string} componentName 模态内部绘制组件名称
   * @param {IData} props 模态内部绘制组件的props
   * @param {AppModalOptions} [opts] 模态相关的配置参数
   * @returns {*}  {Promise<IModalData>}
   */
  public static openModal(
    componentName: string,
    props: IData,
    opts?: AppModalOptions,
  ): Promise<IModalData> {
    return new Promise((resolve, reject) => {
      const vm = new Vue({
        pinia: piniaInstance,
        render(h) {
          return h(AppModalComponent, {
            props: {
              componentName,
              componentProps: props,
              opts,
              resolve,
              reject,
            },
          });
        },
      }).$mount();
      document.body.appendChild(vm.$el);
    });
  }
}
