import { defineComponent } from 'vue';
import {
  getGridDropdownProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridDropdown = defineComponent({
  name: 'IBizGridDropdown',
  props: getGridDropdownProps(),
  setup(props) {
    const ns = useNamespace('grid-dropdown');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: props.controller.multiple,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizDropdown', {
          props: {
            ...this.$props,
            infoMode: this.disabled || this.isInfoMode,
            autoFocus: true,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
