import { IModal } from '@ibiz-template/runtime';
import {
  useNamespace,
  useMPickupView2Controller,
} from '@ibiz-template/vue-util';
import {
  defineComponent,
  getCurrentInstance,
  PropType,
  ref,
  Ref,
  VNode,
} from 'vue';
import '@ibiz-template/theme/style/components/views/mpickup-view2/mpickup-view2.scss';

export const MPickupView2 = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useMPickupView2Controller(proxy, props.modelPath);
    const ns = useNamespace('view-dempickupview2');

    // UI层单击选中的数组
    const UISelections: Ref<IData[]> = ref([]);

    const isSelected = (selection: IData) => {
      return UISelections.value.includes(selection);
    };

    const addRight = () => {
      c.addSelectData();
      UISelections.value = [];
    };

    const addRightAll = () => {
      c.selectAll();
      UISelections.value = [];
    };

    const removeRight = () => {
      c.removeSelections(UISelections.value);
      UISelections.value = [];
    };
    const removeRightAll = () => {
      c.removeAllSelections();
      UISelections.value = [];
    };

    const handleSelectionClick = (selection: IData) => {
      const index = UISelections.value.indexOf(selection);
      if (index === -1) {
        UISelections.value.push(selection);
      } else {
        UISelections.value.splice(index, 1);
      }
    };
    return {
      ns,
      c,
      addRight,
      addRightAll,
      removeRight,
      removeRightAll,
      isSelected,
      handleSelectionClick,
    };
  },
  render(h) {
    let panelComponent = null;
    let treeComponent: VNode | null = null;

    if (this.c.complete) {
      const { tree, pickupViewPanel } = this.c.model;
      if (this.c.providers[tree.name]) {
        treeComponent = h(this.c.providers[tree.name].component, {
          props: {
            modelData: tree,
            context: this.c.context,
            params: this.c.params,
            isSelectFirstDefault: true,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit('tree'),
          },
        });
      }
      if (this.c.providers[pickupViewPanel.name]) {
        panelComponent = h(this.c.providers[pickupViewPanel.name].component, {
          props: {
            modelData: pickupViewPanel,
            context: this.c.navPanelParams.context,
            params: this.c.navPanelParams.params,
            noLoadDefault: true,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(pickupViewPanel.name),
          },
        });
      }
    }
    return (
      <view-base
        controller={this.c}
        scopedSlots={{
          footer: () => {
            return (
              <div class={this.ns.b('footer')}>
                <i-button
                  on-click={() => {
                    this.c.onOkButtonClick();
                  }}
                >
                  确定
                </i-button>
                <i-button
                  on-click={() => {
                    this.c.onCancelButtonClick();
                  }}
                >
                  取消
                </i-button>
              </div>
            );
          },
        }}
      >
        <div class={this.ns.b('content')}>
          <div class={this.ns.b('left-container')}>
            <div class={this.ns.b('left-container-left')}>{treeComponent}</div>
            <div class={this.ns.b('left-container-right')}>
              {panelComponent}
            </div>
          </div>
          <div class={this.ns.b('center')}>
            <i-button on-click={this.addRight} title='右移'>
              {'>'}
            </i-button>
            <i-button on-click={this.removeRight} title='左移'>
              {'<'}
            </i-button>
            <i-button on-click={this.addRightAll} title='全部右移'>
              {'>>'}
            </i-button>
            <i-button on-click={this.removeRightAll} title='全部左移'>
              {'<<'}
            </i-button>
          </div>
          <div class={this.ns.b('right')}>
            {this.c.selfSelection.map(item => {
              return (
                <div
                  key={item.srfkey}
                  class={[
                    this.ns.be('right', 'list-item'),
                    this.ns.is('selected', this.isSelected(item)),
                  ]}
                  on-click={() => this.handleSelectionClick(item)}
                >
                  {item.srfmajortext}
                  <i-icon
                    type='ios-close'
                    size={24}
                    on-click={() => {
                      this.c.removeSelections([item]);
                    }}
                  />
                </div>
              );
            })}
          </div>
        </div>
      </view-base>
    );
  },
});
