import { defineComponent } from 'vue';
import { ControlModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/layout/control-layout/control-layout.scss';

/**
 * 部件布局
 */
export default defineComponent({
  props: {
    modelData: ControlModel,
  },
  setup(props) {
    const ns = useNamespace('control-layout');
    const type = props.modelData?.source.controlType.toLowerCase();
    const sysCssName = props.modelData?.sysCssName;

    return { ns, type, sysCssName };
  },
  render() {
    return (
      <div class={[this.ns.b(), this.ns.m(this.type), this.sysCssName]}>
        {this.$slots.default}
      </div>
    );
  },
});
