import { PortletPartController } from '@ibiz-template/controller';
import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent } from 'vue';
import { IPSUIActionGroupDetail } from '@ibiz-template/model';
import './portlet-layout.scss';

/**
 * 门户控件布局
 */
export const PortletLayout = defineComponent({
  props: {
    controller: {
      type: PortletPartController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('portlet-layout');
    const c = props.controller;
    // 处理标题
    const isShowHeader = computed(() => {
      // return c.model.showTitleBar || c.model.actionGroup;
      return c.model.showTitleBar;
    });

    // 点击工具栏处理
    const onActionClick = async (
      detail: IPSUIActionGroupDetail,
      event: MouseEvent,
    ) => {
      await props.controller.onActionClick(detail, event);
    };

    return { ns, isShowHeader, onActionClick };
  },
  render() {
    const { model, state } = this.controller;
    return (
      <div class={[this.ns.b(), this.ns.is('no-header', !this.isShowHeader)]}>
        {this.isShowHeader && (
          <div key='header' class={this.ns.b('header')}>
            <div class={this.ns.be('header', 'left')}>
              {model.showTitleBar && (
                <div class={this.ns.e('caption')}>
                  <app-icon
                    class={this.ns.e('caption-icon')}
                    icon={model.source.getPSSysImage()}
                  ></app-icon>
                  <span class={this.ns.e('caption-text')} title={model.title}>
                    {model.title}
                  </span>
                </div>
              )}
            </div>
            <div class={this.ns.be('header', 'right')}>
              {model.actionGroup && state.actionGroupState && (
                <action-toolbar
                  class={this.ns.e('toolbar')}
                  actionGroup={model.actionGroup}
                  actionsState={state.actionGroupState}
                  on-action-click={this.onActionClick}
                ></action-toolbar>
              )}
            </div>
          </div>
        )}
        <div key='content' class={this.ns.b('content')}>
          {this.$slots.default}
        </div>
      </div>
    );
  },
});
