import { TextBoxEditorModel } from '@ibiz-template/model';
import {
  IEditorProvider,
  FormItemController,
  GridEditItemController,
  TextBoxEditorController,
} from '@ibiz-template/controller';
/**
 * 输入框编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class TextBoxEditorProvider
 * @implements {EditorProvider}
 */
export class TextBoxEditorProvider
  implements IEditorProvider<TextBoxEditorController>
{
  formEditor: string = 'IBizInputBox';

  rowEditor: string = 'IBizInputBox';

  constructor(editorType?: string) {
    if (editorType === 'NUMBER') {
      this.formEditor = 'AppInputNumber';
      this.rowEditor = 'AppInputNumber';
    }
  }

  async createController(
    editorModel: TextBoxEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<TextBoxEditorController> {
    const c = new TextBoxEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
