import { FileUploaderEditorModel } from '@ibiz-template/model';
import { IEditorProvider } from '@ibiz-template/controller';
import { FormItemController } from '@ibiz-template/controller/src/control/form';
import { GridEditItemController } from '@ibiz-template/controller/src/control/grid';
import { UploadEditorController } from '@ibiz-template/controller/src/editor';
/**
 * 文件上传编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FileUploaderEditorProvider
 * @implements {EditorProvider}
 */
export class FileUploaderEditorProvider
  implements IEditorProvider<UploadEditorController>
{
  formEditor: string = 'IBizFileUpload';

  rowEditor: string = 'IBizFileUpload';

  constructor(editorType: string) {
    if (editorType === 'PICTURE') {
      this.formEditor = 'AppImageUpload';
      this.rowEditor = 'AppImageUpload';
    } else if (editorType === 'FILEUPLOADER') {
      this.formEditor = 'IBizFileUpload';
      this.rowEditor = 'AppFileUploadRowPreview';
    }
  }

  async createController(
    editorModel: FileUploaderEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<UploadEditorController> {
    const c = new UploadEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
