import {
  GridUAColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { IPSUIActionGroupDetail } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';
import '@/styles/components/widgets/grid/grid-ua-column.scss';

export const GridUAColumn = defineComponent({
  name: 'GridUAColumn',
  props: {
    uaColumn: {
      type: GridUAColumnController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-ua-column');
    const onStopPropagation = (e: MouseEvent) => {
      e.stopPropagation();
    };
    const onActionClick = async (
      detail: IPSUIActionGroupDetail,
      event: MouseEvent,
    ) => {
      await props.uaColumn.onActionClick(detail, props.row, event);
    };

    return { ns, onStopPropagation, onActionClick };
  },
  render() {
    return (
      <div
        class={this.ns.b()}
        on-dblclick={this.onStopPropagation}
        onClick={this.onStopPropagation}
      >
        {!this.uaColumn.model.actionGroup ? null : (
          <actionToolbar
            action-group={this.uaColumn.model.actionGroup}
            actions-state={
              this.row.uaColumnStates[this.uaColumn.model.codeName]
            }
            on-action-click={this.onActionClick}
          ></actionToolbar>
        )}
      </div>
    );
  },
});
export default GridUAColumn;
