import { PortletPartModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';

export const PortletPart = defineComponent({
  name: 'PortletPart',
  props: {
    modelData: {
      type: PortletPartModel,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('portlet-part');
    return { ns };
  },
  render() {
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    const header: unknown = null;
    return (
      <div class={classArr}>
        {header}
        <div class={[this.ns.b('content')]}>{this.modelData.modelClass}</div>
      </div>
    );
  },
});
