import { PortletContainerModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, VNode } from 'vue';

export const PortletContainer = defineComponent({
  name: 'PortletContainer',
  props: {
    modelData: {
      type: PortletContainerModel,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('portlet-container');
    return { ns };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    const content = (
      <app-row layout={this.modelData.source.getPSLayout()}>
        {defaultSlots.map(slot => {
          const opts = slot.componentOptions!;
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          const props = (opts.propsData || {}) as Record<string, any>;
          return (
            <app-col
              layoutPos={props.modelData.source.getPSLayoutPos()}
              modelData={props.modelData}
            >
              {slot}
            </app-col>
          );
        })}
      </app-row>
    );
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    let header: unknown = null;
    if (this.modelData.showTitleBar) {
      header = (
        <div class={[this.ns.b('header')]}>
          <div class={[this.ns.e('caption')]}>
            {this.modelData.source.title}
          </div>
        </div>
      );
    }
    return (
      <div class={classArr}>
        {header}
        <div class={[this.ns.b('content')]}>{content}</div>
      </div>
    );
  },
});
