import { IBizContext } from '@ibiz-template/core';
import {
  DashboardModel,
  PortletContainerModel,
  PortletPartModel,
} from '@ibiz-template/model';
import { useDashboardController, useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

/**
 * 根据类型绘制数据看板成员
 *
 * @author lxm
 * @date 2022-10-14 17:10:42
 * @param {PortletPartModel} model 模型
 * @param {IData} opts 额外参数
 */
function renderPortletByType(model: PortletPartModel, opts?: IData) {
  // 绘制容器
  if (model.source.portletType === 'CONTAINER') {
    const container = model as PortletContainerModel;
    return (
      <portlet-container modelData={container}>
        {container.children.map(child => renderPortletByType(child, opts))}
      </portlet-container>
    );
  }
  return <portlet-part modelData={model}></portlet-part>;
}

export const DashboardControl = defineComponent({
  name: 'DashboardControl',
  props: {
    modelData: {
      type: DashboardModel,
      required: true,
    },
    context: {
      type: IBizContext,
      required: true,
    },
    params: { type: Object as PropType<IParams>, default: () => ({}) },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useDashboardController(
      proxy,
      props.modelData,
      props.context,
      props.params,
    );

    const ns = useNamespace('dashboard');

    console.log(c.model);

    return { c, ns };
  },

  render() {
    return (
      <control-layout modelData={this.c.model}>
        {this.c.complete && (
          <app-row
            class={[this.ns.b()]}
            layout={this.modelData.source.getPSLayout()}
          >
            {this.modelData.children.map(child => {
              return (
                <app-col
                  layoutPos={child.source.getPSLayoutPos()}
                  modelData={child}
                >
                  {renderPortletByType(child)}
                </app-col>
              );
            })}
          </app-row>
        )}
      </control-layout>
    );
  },
});
