import { ViewType } from '@ibiz-template/model';
import { IModal } from '@ibiz-template/runtime';
import {
  useNamespace,
  useWFDynaStartViewController,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import '@/styles/components/views/wf-dyna-start-view/wf-dyna-start-view.scss';

export const WFDynaStartView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useWFDynaStartViewController(proxy, props.modelPath);
    const ns = useNamespace(
      `view-${ViewType.DE_WF_DYNA_START_VIEW}`.toLowerCase(),
    );
    return { c, ns };
  },
  render() {
    return (
      <view-base
        controller={this.c}
        scopedSlots={{
          footer: () => {
            return (
              <div class={this.ns.b('footer')}>
                <i-button
                  on-click={() => {
                    this.c.onOkButtonClick();
                  }}
                >
                  确定
                </i-button>
                <i-button
                  on-click={() => {
                    this.c.onCancelButtonClick();
                  }}
                >
                  取消
                </i-button>
              </div>
            );
          },
        }}
      >
        {this.c.complete && (
          <edit-form-control
            modelData={this.c.model.forms.get('form')}
            context={this.c.context}
            params={this.c.params}
            on-neuronInit={this.c.nerve.onNeuronInit('form')}
          ></edit-form-control>
        )}
      </view-base>
    );
  },
});
