import { IModal } from '@ibiz-template/runtime';
import { usePickupViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const PickupView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = usePickupViewController(proxy, props.modelPath);

    return { c };
  },
  render() {
    return (
      <view-base controller={this.c}>
        {this.c.complete && this.c.model.pickupViewPanel && (
          <pickup-view-panel
            modelData={this.c.model.pickupViewPanel}
            context={this.c.context}
            params={this.c.params}
            on-neuronInit={this.c.nerve.onNeuronInit(
              this.c.model.pickupViewPanel.source.name,
            )}
          ></pickup-view-panel>
        )}
      </view-base>
    );
  },
});
