import { IModal } from '@ibiz-template/runtime';
import { useEditView3Controller, useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import { getViewComponentName } from '@/util';

export const EditView3 = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useEditView3Controller(proxy, props.modelPath);
    const ns = useNamespace('view-deeditview3');
    return { c, ns };
  },
  render(h) {
    return (
      <view-base controller={this.c}>
        {this.c.complete && (
          <i-tabs
            class={[this.ns.be('', 'tab')]}
            name={this.c.model.drTab.source.name}
          >
            <i-tab-pane
              class={this.ns.be('', 'tab-item')}
              tab={this.c.model.drTab.source.name}
              label={this.c.model.drTab.source.editItemCaption}
              name={'mainForm'}
            >
              <edit-form-control
                modelData={this.c.model.form}
                context={this.c.context}
                params={this.c.params}
                on-neuronInit={this.c.nerve.onNeuronInit(
                  this.c.model.form.source.name,
                )}
              ></edit-form-control>
            </i-tab-pane>
            {[...this.c.model.drTab.pages.values()].map(page => {
              return (
                <i-tab-pane
                  class={this.ns.be('', 'tab-item')}
                  tab={this.c.model.drTab.source.name}
                  disabled={this.c.isNewData}
                  label={page.source.caption}
                  name={page.source.name}
                >
                  {!this.c.isNewData &&
                    h(getViewComponentName(page.embedView.source.viewType), {
                      props: {
                        context: this.c.drPages[page.source.name].context,
                        params: this.c.drPages[page.source.name].params,
                        modal: this.modal,
                        modelPath: page.embedView.source.modelPath,
                      },
                      on: {
                        neuronInit: this.c.nerve.onNeuronInit(page.source.name),
                      },
                      key: this.c.drPages[page.source.name].key,
                    })}
                </i-tab-pane>
              );
            })}
          </i-tabs>
        )}
      </view-base>
    );
  },
});
