import { IModal } from '@ibiz-template/runtime';
import { useEditViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const EditView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useEditViewController(proxy, props.modelPath);
    return { c };
  },
  render() {
    return (
      <view-base controller={this.c}>
        {this.c.complete && (
          <edit-form-control
            modelData={this.c.model.form}
            context={this.c.context}
            params={this.c.params}
            on-neuronInit={this.c.nerve.onNeuronInit(
              this.c.model.form.source.name,
            )}
          ></edit-form-control>
        )}
      </view-base>
    );
  },
});
