import { IModal } from '@ibiz-template/runtime';
import { useAppPortalViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const AppPortalView = defineComponent({
  name: 'AppPortalView',
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useAppPortalViewController(proxy, props.modelPath);
    return { c };
  },
  render() {
    return (
      <view-base controller={this.c}>
        {this.c.complete && (
          <dashboard-control
            modelData={this.c.model.dashboard}
            context={this.c.context}
            params={this.c.params}
            on-neuronInit={this.c.nerve.onNeuronInit(
              this.c.model.dashboard.source.name,
            )}
          ></dashboard-control>
        )}
      </view-base>
    );
  },
});
