import {
  GridEditItemController,
  GridRowController,
} from '@ibiz-template/controller';
import { defineComponent } from 'vue';

export const GridEditItem = defineComponent({
  name: 'GridEditItem',
  props: {
    controller: {
      type: GridEditItemController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    // 编辑器值变更事件
    const onValueChange = (val: unknown, name?: string) => {
      props.controller.setRowValue(props.row, val, name);
    };

    const onStopPropagation = (e: MouseEvent) => {
      e.stopPropagation();
    };

    return { onValueChange, onStopPropagation };
  },
  render(h) {
    const codeName = this.controller.model.codeName;
    return (
      <appGridEditItem
        required={this.controller.required}
        error={this.row.errors[codeName]}
        nativeondblclick={this.onStopPropagation}
        nativeonClick={this.onStopPropagation}
      >
        {this.controller.editorProvider &&
          h(this.controller.editorProvider.rowEditor, {
            props: {
              value: this.row.data[codeName],
              data: this.row.data,
              controller: this.controller.editor,
              disable: this.row.columnState[codeName]!.disabled,
            },
            on: {
              change: (val: unknown, name?: string) => {
                this.onValueChange(val, name);
              },
            },
          })}
      </appGridEditItem>
    );
  },
});
export default GridEditItem;
