import { ViewType } from '@ibiz-template/model';
import { IModal } from '@ibiz-template/runtime';
import {
  useNamespace,
  useWFDynaActionViewController,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import '@/styles/components/views/wf-dyna-action-view/wf-dyna-action-view.scss';

export const WFDynaActionView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useWFDynaActionViewController(proxy, props.modelPath);
    const ns = useNamespace(
      `view-${ViewType.DE_WF_DYNA_ACTION_VIEW}`.toLowerCase(),
    );
    return { c, ns };
  },
  render(h) {
    let formComponent = null;
    if (this.c.complete) {
      const { activeForm } = this.c;
      if (activeForm && this.c.providers[activeForm.name]) {
        formComponent = h(this.c.providers[activeForm.name].compName, {
          props: {
            modelData: activeForm,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit('form'),
          },
        });
      }
    }
    return (
      <view-base
        controller={this.c}
        scopedSlots={{
          footer: () => {
            return (
              <div class={this.ns.b('footer')}>
                <i-button
                  on-click={() => {
                    this.c.onOkButtonClick();
                  }}
                >
                  确定
                </i-button>
                <i-button
                  on-click={() => {
                    this.c.onCancelButtonClick();
                  }}
                >
                  取消
                </i-button>
              </div>
            );
          },
        }}
      >
        {formComponent}
      </view-base>
    );
  },
});
