import { IModal } from '@ibiz-template/runtime';
import { useNamespace, useOptViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import '@/styles/components/views/opt-view/opt-view.scss';

export const OptView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useOptViewController(proxy, props.modelPath);
    const ns = useNamespace('view-deoptview');
    return { c, ns };
  },
  render(h) {
    let formComponent = null;
    if (this.c.complete) {
      const { form } = this.c.model;
      if (this.c.providers[form.name]) {
        formComponent = h(this.c.providers[form.name].compName, {
          props: {
            modelData: form,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(form.name),
          },
        });
      }
    }
    return (
      <view-base
        class={this.ns.b()}
        controller={this.c}
        scopedSlots={{
          footer: () => {
            return (
              <div class={this.ns.b('footer')}>
                <i-button
                  on-click={() => {
                    this.c.onOkButtonClick();
                  }}
                >
                  确定
                </i-button>
                <i-button
                  on-click={() => {
                    this.c.onCancelButtonClick();
                  }}
                >
                  取消
                </i-button>
              </div>
            );
          },
        }}
      >
        {formComponent}
      </view-base>
    );
  },
});
