import { IBizContext } from '@ibiz-template/core';
import { ViewPanelModel } from '@ibiz-template/model';
import { useViewPanelController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import { IModal, ViewMode } from '@ibiz-template/runtime';

export const ViewPanel = defineComponent({
  props: {
    modelData: {
      type: ViewPanelModel,
      required: true,
    },
    context: {
      type: IBizContext,
      required: true,
    },
    params: { type: Object as PropType<IParams>, default: () => ({}) },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useViewPanelController(
      proxy,
      props.modelData,
      props.context,
      props.params,
    );

    // 模态对象
    const modal: IModal = { mode: ViewMode.EMBED };

    // 视图模型路径
    const viewPath = c.model.embedView.source.modelPath;

    return { c, modal, viewPath };
  },
  render(h) {
    if (!this.c.complete) {
      return;
    }
    return h('ViewShell', {
      props: {
        context: this.c.context,
        params: this.c.params,
        modal: this.modal,
        modelPath: this.viewPath,
      },
      on: {
        neuronInit: this.c.nerve.onNeuronInit('embedView'),
      },
    });
  },
});
