import { IPSAppDEPanelView, IPSPanel } from '@ibiz/dynamic-model-api';
import { DePanelViewInterface, LogUtil, ModelTool } from 'ibiz-core';
import { MainViewBase } from './mainview-base';

/**
 * 实体面板视图基类
 *
 * @export
 * @class DePanelViewBase
 * @extends {MainViewBase}
 * @implements {DePanelViewInterface}
 */
export class DePanelViewBase extends MainViewBase implements DePanelViewInterface {

    /**
     * 实体面板视图实例对象
     * 
     * @memberof DePanelViewBase
     */
    public viewInstance!: IPSAppDEPanelView;

    /**
     * 面板部件实例对象
     * 
     * @memberof DePanelViewBase
     */
    public panelInstance?: IPSPanel;

    /**
     *  视图初始化
     *
     * @memberof DePanelViewBase
     */
    public viewInit() {
        const that = this;
        super.viewInit();
        if (that.portletState) {
            that.portletStateEvent = that.portletState.subscribe((res: any) => {
                if (!Object.is(res.tag, that.viewInstance.name)) {
                    return;
                }
                if (Object.is(res.action, 'load')) {
                    that.viewState.next({
                        tag: that.panelInstance?.name,
                        action: "load",
                        data: res.data
                    });
                }
            })
        }
    }

    /**
     * 视图模型初始化
     * 
     * @memberof DePanelViewBase
     */
    public async viewModelInit() {
        this.viewInstance = (this.staticProps.modeldata) as IPSAppDEPanelView;
        await super.viewModelInit();
        this.panelInstance = ModelTool.findPSControlByType('PANEL', this.viewInstance?.getPSControls() || []);
    }

    /**
     * 视图刷新
     *
     * @param {*} args
     * @memberof DePanelViewBase
     */
    public refresh(args?: any): void {
        const refs: any = this.$refs;
        try {
            if (refs && this.panelInstance && this.panelInstance.name && refs[this.panelInstance.name]) {
                refs[this.panelInstance.name]?.ctrl?.refresh(args);
            }
        } catch (error) {
            LogUtil.log(refs, this.panelInstance)
        }
    }

}