import Router from 'vue-router';
import { AuthGuard } from '../guard';
import RouterShell from '@/components/router-shell/router-shell';
import appRedirectView from '@/views/app-redirect-view/app-redirect-view';
import todoRedirect from '@/views/todo-redirect/todo-redirect';

const router = new Router({
  routes: [
    {
      path: '/',
      redirect: '/index',
    },
    {
      path: '/login',
      name: 'loginView',
      component: () => import('../views/login-view/login-view'),
    },
    {
      path: '/404',
      name: '404View',
      component: () => import('../views/404-view/404-view'),
    },
    {
      path: '/appredirectview',
      name: 'appRedirectView',
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: appRedirectView,
    },
    {
      path: '/todoredirect',
      name: 'todoRedirect',
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: todoRedirect,
    },
    {
      path: '/:view1([^=/]+)/:params1([^/]+=[^/]+)?',
      props: {
        level: 1,
      },
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: RouterShell,
      children: [
        {
          path: '404',
          name: '404View',
          component: () => import('../views/404-view/404-view'),
        },
        {
          path: ':view2([^=/]+)/:params2([^/]+=[^/]+)?',
          props: {
            level: 2,
          },
          component: RouterShell,
          children: [
            {
              path: ':view3([^=/]+)/:params3([^/]+=[^/]+)?',
              props: {
                level: 3,
              },
              component: RouterShell,
            },
          ],
        },
      ],
    },
    {
      path: '*',
      redirect: '/404',
    },
  ],
});

export default router;
