import Vue, { VueConstructor } from 'vue';
import {
  Menu,
  Layout,
  Icon,
  MenuItem,
  Tooltip,
  DropdownItem,
  Dropdown,
  TabPane,
  Table,
  Form,
  FormItem,
  Input,
  Sider,
  Header,
  Content,
  Submenu,
  Avatar,
  DropdownMenu,
  Page,
  Spin,
  Tabs,
  Button,
  Select,
  Option,
  RadioGroup,
  Radio,
  Row,
  Col,
  Tree,
  Checkbox,
  CheckboxGroup,
  DatePicker,
  Upload,
  Message,
  Modal,
  AutoComplete,
  InputNumber,
  Drawer,
  // 绑在原型上
  LoadingBar,
  Notice,
} from 'view-design';

const components = [
  Menu,
  Layout,
  Icon,
  MenuItem,
  Tooltip,
  DropdownItem,
  Dropdown,
  TabPane,
  Table,
  Form,
  FormItem,
  Input,
  Sider,
  Header,
  Content,
  Submenu,
  Avatar,
  DropdownMenu,
  Page,
  Spin,
  Tabs,
  Button,
  Select,
  Option,
  RadioGroup,
  Radio,
  Row,
  Col,
  Tree,
  Checkbox,
  CheckboxGroup,
  DatePicker,
  Upload,
  Message,
  Modal,
  AutoComplete,
  InputNumber,
  Drawer,
];

export const IViewRegister = {
  install(v: VueConstructor) {
    Vue.prototype.$Loading = LoadingBar;
    Vue.prototype.$Message = Message;
    Vue.prototype.$Modal = Modal;
    Vue.prototype.$Notice = Notice;
    Vue.prototype.$Spin = Spin;
    // 需要重命名的
    components.forEach(component => {
      if (component.name) {
        if (component.name.startsWith('i')) {
          v.component(component.name, component);
        } else {
          v.component(`I${component.name}`, component);
        }
      }
    });
  },
};
