const envMap = new Map([
  ['baseUrl', 'BaseUrl'],
  ['remoteModelUrl', 'remoteDynaPath'],
  ['dcSystem', 'mockDcSystemId'],
  ['enablePermission', 'enablePermissionValid'],
]);

export async function attachEnvironmentConfig(): Promise<void> {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const env = (window as any).Environment;

  // environment.js里的值覆盖到ibiz.env里，名称不一致的按envMap映射去修改。
  Object.keys(ibiz.env).forEach(key => {
    const key2 = envMap.has(key) ? envMap.get(key)! : key;
    if (env[key2]) {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (ibiz.env as any)[key] = env[key2];
    }
  });

  if (env.AppTitle) {
    document.title = env.AppTitle;
  }
}
