import { VueConstructor } from 'vue';
import { install as installCore } from '@ibiz-template/core';
import { install as installService } from '@ibiz-template/service';
import { install as installRuntime } from '@ibiz-template/runtime';
import { install as installController } from '@ibiz-template/controller';
import { IViewRegister } from './i-view-register';
import 'view-design/dist/styles/iview.css';
import {
  AppLayout,
  ControlLayout,
  ViewBase,
  ViewLayout,
} from './components/layout';
import {
  AppMenu,
  EditFormControl,
  FormControl,
  FormPage,
  FormPageItem,
  FormGroupPanel,
  FormItemContainer,
  FormItem,
  GridControl,
  SearchFormControl,
  FormTabPanel,
  FormTabPage,
  FormRawItem,
  FormButton,
  FormDRUIPart,
  GridColumn,
  GridUAColumn,
  GridFieldColumn,
  GridEditItem,
  ViewPanel,
  PickupViewPanel,
} from './components/widgets';
import {
  EditView,
  GridView,
  PickupGridView,
  PickupView,
  MPickupView,
  OptView,
  EditView3,
  WFDynaActionView,
  WFDynaEditView3,
  WFDynaStartView,
  WFStepTraceView,
} from './components/views';
import { IndexView } from './views';
import AppKeepAlive from './components/common/app-keep-alive/app-keep-alive.vue';
import {
  AppIcon,
  ViewToolbar,
  WFToolbar,
  QuickSearch,
  AppCol,
  AppRow,
  AppGridPagination,
  AppGridEditItem,
  ActionToolbar,
  AppUser,
  AppTransition,
  WfVersionSelect,
} from './components/common';

// 编辑器组件
import IBizSpan from './components/editor/ibiz-span/ibiz-span';
import IBizInputBox from './components/editor/ibiz-input-box/ibiz-input-box';
import AppInputNumber from './components/editor/app-input-number/app-input-number';
import IBizCheckBoxList from './components/editor/ibiz-check-box-list/ibiz-check-box-list';
import IBizRadioButtonList from './components/editor/ibiz-radio-button-list/ibiz-radio-button-list';
import IBizDatePicker from './components/editor/ibiz-date-picker/ibiz-date-picker';
import IBizDropDownList from './components/editor/ibiz-dropdown-list/ibiz-dropdown-list';
import IBizPicker from './components/editor/ibiz-picker/ibiz-picker';
import AppSelectTree from './components/editor/app-select-tree/app-select-tree';
import IBizPickerDropDown from './components/editor/ibiz-picker-dropdown/ibiz-picker-dropdown';
import AppPickerLinkOnly from './components/editor/app-picker-linkonly/app-picker-linkonly';
import IBizMPicker from './components/editor/ibiz-mpicker/ibiz-mpicker';
import IBizFileUpload from './components/editor/ibiz-file-upload/ibiz-file-upload';
import AppFileUploadRowPreview from './components/editor/app-file-upload-row-preview/app-file-upload-row-preview';
import AppImageUpload from './components/editor/app-image-upload/app-image-upload';
import NotSupportedEditor from './components/editor/not-supported-editor/not-supported-editor';
import { presetEditorProvider } from './provider';
import { MDViewBase } from './components/layout/md-view-base/md-view-base';

export const AppRegister = {
  install(v: VueConstructor) {
    installCore();
    installService();
    installRuntime();
    installController();
    presetEditorProvider();
    v.use(IViewRegister);
    // 注册布局组件
    v.component('AppLayout', AppLayout);
    v.component('ControlLayout', ControlLayout);
    v.component('ViewLayout', ViewLayout);
    v.component('ViewBase', ViewBase);
    v.component('MdViewBase', MDViewBase);
    // 注册视图组件
    v.component('IndexView', IndexView);
    v.component('GridView', GridView);
    v.component('EditView', EditView);
    v.component('EditView3', EditView3);
    v.component('OptView', OptView);
    v.component('PickupGridView', PickupGridView);
    v.component('PickupView', PickupView);
    v.component('MPickupView', MPickupView);
    v.component('WFDynaActionView', WFDynaActionView);
    v.component('WFDynaStartView', WFDynaStartView);
    v.component('WFDynaEditView3', WFDynaEditView3);
    v.component('WFStepTraceView', WFStepTraceView);
    // 注册部件组件
    v.component('AppMenu', AppMenu);
    v.component('GridControl', GridControl);
    v.component('GridColumn', GridColumn);
    v.component('GridUaColumn', GridUAColumn);
    v.component('GridFieldColumn', GridFieldColumn);
    v.component('GridEditItem', GridEditItem);
    v.component('FormButton', FormButton);
    v.component('FormDruipart', FormDRUIPart);
    v.component('FormGroupPanel', FormGroupPanel);
    v.component('AppFormItem', FormItem);
    v.component('FormPage', FormPage);
    v.component('FormPageItem', FormPageItem);
    v.component('FormRawItem', FormRawItem);
    v.component('FormTabPage', FormTabPage);
    v.component('FormTabPanel', FormTabPanel);
    v.component('FormControl', FormControl);
    v.component('EditFormControl', EditFormControl);
    v.component('SearchFormControl', SearchFormControl);
    v.component('ViewPanel', ViewPanel);
    v.component('PickupViewPanel', PickupViewPanel);
    // 注册通用组件
    v.component('AppKeepAlive', AppKeepAlive);
    v.component('AppIcon', AppIcon);
    v.component('AppCol', AppCol);
    v.component('AppRow', AppRow);
    v.component('ViewToolbar', ViewToolbar);
    v.component('WfToolbar', WFToolbar);
    v.component('ActionToolbar', ActionToolbar);
    v.component('AppGridPagination', AppGridPagination);
    v.component('FormItemContainer', FormItemContainer);
    v.component('AppGridEditItem', AppGridEditItem);
    v.component('AppUser', AppUser);
    v.component('AppTransition', AppTransition);
    v.component('WfVersionSelect', WfVersionSelect);
    // 注册编辑器组件
    v.component('IBizSpan', IBizSpan);
    v.component('IBizInputBox', IBizInputBox);
    v.component('AppInputNumber', AppInputNumber);
    v.component('IBizCheckBoxList', IBizCheckBoxList);
    v.component('IBizRadioButtonList', IBizRadioButtonList);
    v.component('IBizDatePicker', IBizDatePicker);
    v.component('IBizDropDownList', IBizDropDownList);
    v.component('IBizPicker', IBizPicker);
    v.component('IBizPickerDropDown', IBizPickerDropDown);
    v.component('AppPickerLinkOnly', AppPickerLinkOnly);
    v.component('IBizMPicker', IBizMPicker);
    v.component('IBizFileUpload', IBizFileUpload);
    v.component('AppFileUploadRowPreview', AppFileUploadRowPreview);
    v.component('AppImageUpload', AppImageUpload);
    v.component('AppSelectTree', AppSelectTree);
    v.component('QuickSearch', QuickSearch);
    v.component('NotSupportedEditor', NotSupportedEditor);
  },
};
