import { SpanEditorModel } from '@ibiz-template/model';
import { IEditorProvider } from '@ibiz-template/runtime';
import { FormItemController } from '@ibiz-template/controller/src/control/form';
import { GridEditItemController } from '@ibiz-template/controller/src/control/grid';
import { SpanEditorController } from '@ibiz-template/controller/src/editor';
/**
 * 标签编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class SpanEditorProvider
 * @implements {EditorProvider}
 */
export class SpanEditorProvider
  implements IEditorProvider<SpanEditorController>
{
  formEditor: string = 'IBizSpan';

  rowEditor: string = 'IBizSpan';

  async createController(
    editorModel: SpanEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<SpanEditorController> {
    const c = new SpanEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
