import { DatePickerEditorModel } from '@ibiz-template/model';
import { IEditorProvider } from '@ibiz-template/runtime';
import { FormItemController } from '@ibiz-template/controller/src/control/form';
import { GridEditItemController } from '@ibiz-template/controller/src/control/grid';
import { DatePickerEditorController } from '@ibiz-template/controller/src/editor';

/**
 * 日期时间选择器编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class DatePickerEditorProvider
 * @implements {EditorProvider}
 */
export class DatePickerEditorProvider
  implements IEditorProvider<DatePickerEditorController>
{
  formEditor: string = 'IBizDatePicker';

  rowEditor: string = 'IBizDatePicker';

  async createController(
    editorModel: DatePickerEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<DatePickerEditorController> {
    const c = new DatePickerEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
