import { IModal } from '@ibiz-template/runtime';
import {
  usePropsWatch,
  useWFStepTraceViewController,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const WFStepTraceView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    deName: { type: String, required: true },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useWFStepTraceViewController(proxy, props.modelPath);
    // 监听prop，并响应式更新到controller
    usePropsWatch(proxy, 'deName', c.setDeName.bind(c));

    return { c };
  },
  render() {
    return <view-base controller={this.c}>审批日志</view-base>;
  },
});
