import { defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@/styles/components/common/wf-toolbar/wf-toolbar.scss';
import { WFLink } from '@ibiz-template/controller';

export const WFToolbar = defineComponent({
  name: 'WFToolbar',
  props: {
    wfLinks: {
      type: Array<WFLink>,
      required: true,
    },
  },
  setup(props, { emit }) {
    const ns = useNamespace('wf-toolbar');

    // 点击事件抛给表格执行
    const handleClick = async (link: WFLink, event: MouseEvent) => {
      emit('wf-link-click', link, event);
    };

    return { ns, handleClick };
  },
  render() {
    const wfLinks = this.wfLinks || [];
    return (
      <div class={`${this.ns.b()}`}>
        {wfLinks.length > 0 &&
          wfLinks.map(link => {
            return (
              <div key={link.sequenceFlowId} class={this.ns.e('item')}>
                <i-button
                  title={link.sequenceFlowName}
                  on-click={(e: MouseEvent) => this.handleClick(link, e)}
                >
                  {link.sequenceFlowName || ''}
                </i-button>
              </div>
            );
          })}
      </div>
    );
  },
});
