import { FormDRUIPartModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormDRUIPartController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单按钮适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormDRUIPartProvider
 * @implements {EditorProvider}
 */
export class FormDRUIPartProvider
  implements IFormDetailProvider<FormDRUIPartController>
{
  compName: string = 'FormDruipart';

  async createController(
    detailModel: FormDRUIPartModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormDRUIPartController> {
    const c = new FormDRUIPartController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
