import { defineComponent, ref } from 'vue';
import {
  getEditorEmits,
  getUploadProps,
  useNamespace,
} from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/editor/ibiz-file-upload/ibiz-file-upload.scss';
import { useIViewUpload } from '../use/use-iview-upload';

export const IBizFileUploadOne = defineComponent({
  name: 'IBizFileUploadOne',
  props: getUploadProps(),
  emits: getEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('file-upload');
    const c = props.controller;
    const fileUpload = ref();

    const {
      uploadUrl,
      headers,
      files,
      onDownload,
      onError,
      onRemove,
      onSuccess,
      beforeUpload,
    } = useIViewUpload(
      props,
      value => {
        emit('change', value);
      },
      c,
    );

    const handleBeforeUpload = (_files: IData) => {
      // 先清除之前的文件 todo
      fileUpload.value.clearFiles();
      return beforeUpload(_files);
    };

    return {
      ns,
      c,
      uploadUrl,
      headers,
      files,
      fileUpload,
      onDownload,
      onError,
      onRemove,
      onSuccess,
      beforeUpload,
      handleBeforeUpload,
    };
  },
  render(h) {
    return (
      <div
        class={[
          this.ns.b(),
          this.disabled ? this.ns.m('disabled') : '',
          this.readonly ? this.ns.m('readonly') : '',
        ]}
      >
        {h(
          'IUpload',
          {
            ref: 'fileUpload',
            props: {
              action: this.uploadUrl,
              headers: this.headers,
              disabled: this.disabled,
              'default-file-list': this.files,
              multiple: false,
              type: this.c.model.isDrag ? 'drag' : 'select',
              accept: this.c.model.accept,
              'before-upload': this.handleBeforeUpload,
              'on-success': this.onSuccess,
              'on-error': this.onError,
              'on-remove': this.onRemove,
              'on-preview': this.onDownload,
            },
          },
          [
            this.c.model.isDrag ? (
              <div class={this.ns.b('drag-box')}>
                <div class={this.ns.be('drag-box', 'caption')}>
                  <div class={this.ns.bem('drag-box', 'caption', 'click')}>
                    点击上传
                  </div>
                  <div>/</div>
                  <div class={this.ns.bem('drag-box', 'caption', 'drag')}>
                    拖拽到此区域
                  </div>
                </div>
                {this.c.uploadDescription && !this.readonly && (
                  <div class={this.ns.be('drag-box', 'accept-description')}>
                    {this.c.uploadDescription}
                  </div>
                )}
              </div>
            ) : (
              [
                <i-button
                  icon='ios-cloud-upload-outline'
                  class={this.ns.b('button')}
                >
                  上传文件
                </i-button>,
                this.c.uploadDescription && !this.readonly && (
                  <div
                    class={this.ns.be('button-upload', 'accept-description')}
                  >
                    {this.c.uploadDescription}
                  </div>
                ),
              ]
            ),
          ],
        )}
      </div>
    );
  },
});
