import { defineComponent } from 'vue';
import {
  getGridEditorEmits,
  getGridInputNumberProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridInputNumber = defineComponent({
  name: 'IBizGridInputNumber',
  props: getGridInputNumberProps(),
  emits: getGridEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('grid-input-number');
    const { isInfoMode, autoFocus, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props, { emit });

    return {
      ns,
      isInfoMode,
      autoFocus,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizInputNumber', {
          props: {
            ...this.$props,
            readonly: this.isInfoMode,
            disabled: this.disabled,
            autoFocus: this.autoFocus,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
