/* eslint-disable no-param-reassign */
import { defineComponent, PropType, watch, Ref, ref } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import dayjs from 'dayjs';
import { clone } from 'ramda';
import '@ibiz-template/theme/style/components/common/extend-action-timeline/extend-action-timeline.scss';

/**
 * 办理人员名称显示去重
 *
 * @param tag 需要去重的名称标识
 * @param dataS 需要去重数据集
 */
const acceptingOfficerNoDup = (tag: string, dataS: IData[]) => {
  const tempData: IData[] = [];
  if (dataS?.length > 0 && tag) {
    dataS.forEach((data: IData) => {
      tempData.push(data[tag]);
    });
  }
  const noDup = [...new Set(tempData)];
  return noDup;
};

export const ExtendActionTimeLine = defineComponent({
  name: 'ExtendActionTimeLine',
  props: {
    data: {
      type: Object as PropType<IData>,
    },
  },
  setup(props) {
    const ns = useNamespace('extend-action-timeline');

    const UIData: Ref<IData[]> = ref([]);

    const sortData = (a: IData, b: IData) => {
      return Date.parse(b.time) - Date.parse(a.time);
    };

    watch(
      () => props.data,
      (newVal, oldVal) => {
        if (newVal !== oldVal && newVal) {
          const commentsData: IData[] = [];
          const copyData = clone(newVal);
          let tasks = copyData.usertasks;
          if (tasks.length > 0) {
            tasks = tasks.reverse();
            tasks.forEach((task: IData) => {
              if (task.identitylinks.length > 0) {
                const authorNames = acceptingOfficerNoDup(
                  'displayname',
                  task.identitylinks,
                );
                commentsData.push({
                  authorName: authorNames.join('、'),
                  taskName: task.userTaskName,
                  isLink: true,
                });
              }
              if (task.comments.length > 0) {
                task.comments.forEach((comment: IData) => {
                  Object.assign(comment, { taskName: task.userTaskName });
                });
                task.comments.sort(sortData);
                commentsData.push(...task.comments);
              }
            });
            UIData.value = commentsData;
          }
        }
      },
      { immediate: true },
    );

    /**
     * 时间转换
     *
     *  @memberof ExtendActionTimeline
     */
    const formatDate = (date: string, format: string) => {
      return dayjs(date).format(format);
    };

    return { ns, formatDate, UIData };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        {this.UIData &&
          this.UIData.map((task: IData) => {
            return (
              <div
                class={[
                  this.ns.b('task'),
                  this.ns.is('wrong', task.type && task.type.includes('驳回')),
                  this.ns.is('link', task.isLink),
                ]}
              >
                <div class={this.ns.be('task', 'tail')}></div>
                <div class={this.ns.be('task', 'head')}></div>
                <div class={this.ns.be('task', 'top')}>
                  <div class={this.ns.be('task', 'user-task-name')}>
                    {task.taskName}
                  </div>
                  <div class={this.ns.be('task', 'author-name')}>
                    {task.authorName}
                  </div>
                  {task.type && (
                    <div class={this.ns.be('task', 'type')}>{task.type}</div>
                  )}
                  {task.time && (
                    <div class={this.ns.be('task', 'last-time')}>
                      {task.time && '处理时间'}
                      <span class={this.ns.be('task', 'last-time-text')}>
                        {task.time}
                      </span>
                    </div>
                  )}
                </div>
                <div class={this.ns.be('task', 'bottom')}>
                  <div class={this.ns.be('task', 'full-message')}>
                    {task.fullMessage}
                  </div>
                </div>
              </div>
            );
          })}
      </div>
    );
  },
});
