import {
  ChartPortletController,
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
} from '@ibiz-template/controller';
import { ChartPortletModel, PortletPartModel } from '@ibiz-template/model';

/**
 * 数据看板成员实体图表适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class ChartPortletProvider
 */
export class ChartPortletProvider implements IPortletPartProvider {
  compName: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<ChartPortletController> {
    const c = new ChartPortletController(
      portletModel as ChartPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
