import { defineComponent } from 'vue';
import {
  getGridInputProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/editor/ibiz-input/ibiz-input.scss';

export const IBizGridInput = defineComponent({
  name: 'IBizGridInput',
  props: getGridInputProps(),
  setup(props) {
    const ns = useNamespace('grid-input');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, {
        isCacheValue: true,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <div
        ref='componentRef'
        class={`${this.ns.b()} ibiz-grid-editor`}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {h('IBizInput', {
          props: {
            ...this.$props,
            infoMode: this.isInfoMode,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </div>
    );
  },
});
