import Vue from 'vue';
import { IModalUtil, ModalParams } from '@ibiz-template/runtime';
import { ModalInstance } from 'view-design';

/**
 * 简洁确认操作框
 *
 * @author chitanda
 * @date 2022-08-17 16:08:52
 * @export
 * @class ModalUtil
 * @implements {IModalUtil}
 */
export class ModalUtil implements IModalUtil {
  protected modal: ModalInstance = Vue.prototype.$Modal;

  async info(params: ModalParams): Promise<void> {
    this.modal.info(params);
  }

  async success(params: ModalParams): Promise<void> {
    this.modal.success(params);
  }

  async warning(params: ModalParams): Promise<void> {
    this.modal.warning(params);
  }

  async error(params: ModalParams): Promise<void> {
    this.modal.error(params);
  }

  async confirm(params: ModalParams): Promise<boolean> {
    return new Promise(resolve => {
      this.modal.confirm({
        ...params,
        onOk: () => {
          resolve(true);
        },
        onCancel: () => {
          resolve(false);
        },
      });
    });
  }
}
