import { ViewType } from '@ibiz-template/model';

/**
 * 根据视图类型返回视图组件的名称
 *
 * @author lxm
 * @date 2022-09-08 18:09:39
 * @export
 * @param {string} viewType
 * @returns {*}
 */
export function getViewComponentName(viewType: string) {
  // 确定视图组件
  switch (viewType) {
    case ViewType.APP_INDEX_VIEW:
      return 'IndexView';
    case ViewType.DE_GRID_VIEW:
    case ViewType.DE_GRID_VIEW9:
      return 'GridView';
    case ViewType.DE_EDIT_VIEW:
      return 'EditView';
    case ViewType.DE_EDIT_VIEW3:
      return 'EditView3';
    case ViewType.DE_OPT_VIEW:
      return 'OptView';
    case ViewType.DE_PICKUP_VIEW:
      return 'PickupView';
    case ViewType.DE_MPICKUP_VIEW:
      return 'MPickupView';
    case ViewType.DE_PICKUP_GRID_VIEW:
      return 'PickupGridView';
    case ViewType.DE_WF_DYNA_EDIT_VIEW3:
      return 'WFDynaEditView3';
    case ViewType.DE_WF_DYNA_START_VIEW:
      return 'WFDynaStartView';
    case ViewType.DE_WF_DYNA_ACTION_VIEW:
      return 'WFDynaActionView';
    case ViewType.APP_WF_STEP_TRACE_VIEW:
      return 'WFStepTraceView';
    case ViewType.APP_PORTAL_VIEW:
      return 'AppPortalView';
    default:
      return '';
  }
}
