/**
 * 远程插件配置
 *
 * @author chitanda
 * @date 2022-10-31 16:10:34
 * @export
 * @interface RemotePluginConfig
 */
export interface RemotePluginConfig {
  /**
   * 脚本地址
   *
   * @author chitanda
   * @date 2022-10-31 16:10:42
   * @type {string}
   */
  script: string;
  /**
   * 样式地址
   *
   * @author chitanda
   * @date 2022-10-31 16:10:46
   * @type {(string | string[])}
   */
  styles: string | string[];
  /**
   * 是否为应用级
   *
   * @author chitanda
   * @date 2022-10-31 16:10:51
   * @type {boolean}
   */
  app?: boolean;
}

/**
 * 远程插件项
 *
 * @author chitanda
 * @date 2022-10-31 12:10:41
 * @export
 * @class RemotePluginItem
 */
export class RemotePluginItem {
  /**
   * 唯一标识
   *
   * @author chitanda
   * @date 2022-10-31 12:10:48
   * @type {string}
   */
  readonly tag: string;

  /**
   * 脚本文件地址
   *
   * @author chitanda
   * @date 2022-10-31 12:10:05
   * @type {string}
   */
  readonly script: string = '';

  /**
   * 样式文件地址
   *
   * @author chitanda
   * @date 2022-10-31 12:10:27
   * @type {(string | string[])}
   */
  readonly styles: string | string[] = '';

  /**
   * 是否为应用级插件
   *
   * @author chitanda
   * @date 2022-10-31 16:10:13
   * @type {boolean}
   */
  readonly app?: boolean;

  /**
   * Creates an instance of RemotePluginItem.
   *
   * @author chitanda
   * @date 2022-10-31 12:10:28
   * @param {string} tag 插件唯一标识
   * @param {RemotePluginConfig} config
   */
  constructor(tag: string, config: RemotePluginConfig) {
    this.tag = tag;
    if (config.script) {
      this.script = config.script;
    }
    if (config.styles) {
      this.styles = config.styles;
    }
    if (config.app) {
      this.app = true;
    }
  }
}
