import {
  GridFieldColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { computed, defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/widgets/grid/grid-field-column.scss';

export const GridFieldColumn = defineComponent({
  name: 'GridFieldColumn',
  props: {
    controller: {
      type: GridFieldColumnController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-field-column');
    const codeListText = computed(() => {
      if (props.controller.codeListItems?.length) {
        const value = props.row.data[props.controller.model.codeName];
        const findItem = props.controller.codeListItems.find(
          item => item.value === value,
        );
        return findItem?.text;
      }
      return null;
    });

    /**
     * 单元格点击事件
     *
     * @author lxm
     * @date 2022-09-28 18:09:27
     * @param {MouseEvent} event
     */
    const onCellClick = (event: MouseEvent) => {
      if (props.controller.isLinkColumn) {
        props.controller.openLinkView(props.row, event);
      }
    };

    return { ns, codeListText, onCellClick };
  },
  render() {
    const c = this.controller;
    const value = this.row.data[c.model.codeName];
    return (
      <span
        class={[this.ns.b(), c.isLinkColumn && this.ns.m('link-column')]}
        onClick={this.onCellClick}
      >
        {this.codeListText || value}
      </span>
    );
  },
});
export default GridFieldColumn;
