import { defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';

export const AppGridEditItem = defineComponent({
  name: 'AppGridEditItem',
  props: {
    required: {
      type: Boolean,
    },
    error: {
      type: String || null,
    },
  },
  setup() {
    const ns = useNamespace('grid-edit-item');
    return { ns };
  },
  render() {
    return (
      <div class={[this.ns.b(), this.ns.is('error', !!this.error)]}>
        <i-tooltip
          content={this.error}
          class={this.ns.e('tooltip')}
          disabled={!this.error}
          transfer
          transfer-class-name={this.ns.e('tooltip-popper')}
          placement='top'
        >
          {this.$slots.default}
        </i-tooltip>
      </div>
    );
  },
});
export default AppGridEditItem;
