import { GridFieldColumnProvider } from './grid-field-column-provider';
import { GridFieldEditColumnProvider } from './grid-field-edit-column-provider';
import { GridUAColumnProvider } from './grid-ua-column-provider';

/**
 * 预置默认的表格列适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:50
 * @export
 */
export function presetGridColumnProvider(): void {
  const { gridColumn } = ibiz.register;
  if (!gridColumn) {
    return;
  }
  // 表格属性列
  gridColumn.register('DEFGRIDCOLUMN', new GridFieldColumnProvider());
  // 表格属性列（开启行编辑）
  gridColumn.register('DEFGRIDCOLUMN_EDIT', new GridFieldEditColumnProvider());
  // 表格操作列
  gridColumn.register('UAGRIDCOLUMN', new GridUAColumnProvider());
  // todo 表格分组列 GROUPGRIDCOLUMN
}

export {
  GridFieldColumnProvider,
  GridUAColumnProvider,
  GridFieldEditColumnProvider,
};
