import { IModal, ViewMode } from '@ibiz-template/runtime';
import {
  defineComponent,
  PropType,
  h,
  ref,
  Ref,
  toRef,
  getCurrentInstance,
  VNode,
} from 'vue';
import qs from 'qs';
import {
  useListExpViewController,
  useRoute,
  useRouteKey,
} from '@ibiz-template/vue-util';

export const ListExpView = defineComponent({
  name: 'ListExpView',
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    srfnav: String,
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useListExpViewController(proxy, props.modelPath);
    const routeViewKey: Ref<string> = ref('');
    const defaultSelectKeys: Ref<string[]> = ref([]);

    if (c.context.isRouter === true) {
      const route = useRoute(proxy);

      // 第一次设置key是由自身通知，后续走监听
      c.nerve.self.evt.on('created', () => {
        // 解析首页上下文参数里的主键
        if (route.params.params1) {
          const params1Str = route.params.params1 as string;
          const params1Obj = qs.parse(params1Str, { delimiter: ';' });
          const key = params1Obj[c.model.appEntity.deName] as string;
          if (key) {
            c.navItem.key = key;
            defaultSelectKeys.value = [key];
          }
        }
        // 监听并变更routeViewKey
        useRouteKey(toRef(c.navItem, 'key'), proxy, routeViewKey);
      });
    }

    return { c, defaultSelectKeys, routeViewKey };
  },
  render() {
    const isRouter = this.c.context.isRouter === true;
    let listComponent: VNode | null = null;
    let expBarModel = null;
    if (this.c.complete) {
      const { listExpBar } = this.c.model;
      const { list } = listExpBar;
      expBarModel = listExpBar;
      if (this.c.providers[list.name]) {
        listComponent = h(this.c.providers[list.name].component, {
          props: {
            modelData: list,
            context: this.c.context,
            params: this.c.params,
            isExpView: true,
            isSelectFirstDefault: true,
            mdCtrlActiveMode: 1,
            defaultSelectKeys: this.defaultSelectKeys,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(list.name),
          },
        });
      }
    }
    return (
      <exp-view-base
        controller={this.c}
        expBarModel={expBarModel}
        scopedSlots={{
          default: () => listComponent,
          expView: () => {
            if (this.c.complete) {
              const { listExpBar } = this.c.model;
              const { list } = listExpBar;
              if (!list.navView) {
                return null;
              }
              if (isRouter) {
                if (this.routeViewKey) {
                  return (
                    <router-view
                      key={this.routeViewKey}
                      on-neuron-init={this.c.nerve.onNeuronInit('navView')}
                    ></router-view>
                  );
                }
                return null;
              }
              // 非路由模式下绘制嵌入视图
              return h('ViewShell', {
                attrs: {
                  context: this.c.navItem.context,
                  params: this.c.navItem.params,
                  modal: { mode: ViewMode.EMBED },
                  modelPath: list.navView.source.modelPath,
                },
                on: {
                  neuronInit: this.c.nerve.onNeuronInit('navView'),
                },
                key: this.c.navItem.key,
              });
            }
          },
        }}
      ></exp-view-base>
    );
  },
});
