import { CodeListService } from '../app/codelist-service';
import { EntityBaseService, IContext, HttpResponse } from 'ibiz-core';
import { GlobalService } from '../global.service';
import { IRawMaterial, RawMaterial } from '../../entities';
import keys from '../../entities/raw-material/raw-material-keys';
import { RawMaterialDTOHelp } from '../../entities/raw-material/raw-material-dto-help';


/**
 * 原材料服务对象基类
 *
 * @export
 * @class RawMaterialBaseService
 * @extends {EntityBaseService}
 */
export class RawMaterialBaseService extends EntityBaseService<IRawMaterial> {
    protected get keys(): string[] {
        return keys;
    }
    protected SYSTEMNAME = 'TrainSys';
    protected APPNAME = 'Web';
    protected APPDENAME = 'RawMaterial';
    protected APPWFDENAME = 'RAWMATERIAL';
    protected APPDENAMEPLURAL = 'RawMaterials';
    protected dynaModelFilePath:string = 'PSSYSAPPS/Web/PSAPPDATAENTITIES/RawMaterial.json';
    protected APPDEKEY = 'rawmaterialid';
    protected APPDETEXT = 'rawmaterialname';
    protected quickSearchFields = ['rawmaterialname',];
    protected selectContextParam = {
    };

    constructor(opts?: any) {
        super(opts, 'RawMaterial');
    }

    newEntity(data: IRawMaterial): RawMaterial {
        return new RawMaterial(data);
    }

    /**
     * Select
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async Select(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/rawmaterials/select`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
}
