import { RawMaterialAuthServiceBase } from './raw-material-auth-service-base';


/**
 * 原材料权限服务对象
 *
 * @export
 * @class RawMaterialAuthService
 * @extends {RawMaterialAuthServiceBase}
 */
export default class RawMaterialAuthService extends RawMaterialAuthServiceBase {

    /**
     * 基础权限服务实例
     * 
     * @private
     * @type {RawMaterialAuthService}
     * @memberof RawMaterialAuthService
     */
    private static basicUIServiceInstance: RawMaterialAuthService;

     /**
      * 动态模型服务存储Map对象
      *
      * @private
      * @type {Map<string, any>}
      * @memberof RawMaterialAuthService
      */
    private static AuthServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  RawMaterialAuthService.
     * 
     * @param {*} [opts={}]
     * @memberof  RawMaterialAuthService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof RawMaterialAuthService
     */
     public static getInstance(context: any): RawMaterialAuthService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new RawMaterialAuthService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!RawMaterialAuthService.AuthServiceMap.get(context.srfdynainstid)) {
                RawMaterialAuthService.AuthServiceMap.set(context.srfdynainstid, new RawMaterialAuthService({context:context}));
            }
            return RawMaterialAuthService.AuthServiceMap.get(context.srfdynainstid);
        }
    }


}