import {
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
  ViewPortletController,
} from '@ibiz-template/controller';
import { PortletPartModel, ViewPortletModel } from '@ibiz-template/model';

/**
 * 数据看板成员系统视图适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class ViewPortletProvider
 */
export class ViewPortletProvider implements IPortletPartProvider {
  component: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<ViewPortletController> {
    const c = new ViewPortletController(
      portletModel as ViewPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
