import { CreateElement } from 'vue';
import { Prop, Watch } from 'vue-property-decorator';
import { Util } from 'ibiz-core';
import { AppLayoutService } from '../../../app-service';
import { GridView4Base } from '../../../view';

/**
 * 应用实体表格视图(上下关系)基类
 *
 * @export
 * @class AppGridView4Base
 * @extends {GridViewBase}
 */
export class AppGridView4Base extends GridView4Base {

    /**
     * 视图动态参数
     *
     * @type {string}
     * @memberof AppGridView4Base
     */
    @Prop() public declare dynamicProps: any;

    /**
     * 视图静态参数
     *
     * @type {string}
     * @memberof AppGridView4Base
     */
    @Prop() public declare staticProps: any;

    /**
     * 监听视图动态参数变化
     *
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof AppGridView4Base
     */
    @Watch('dynamicProps', {
        immediate: true,
    })
    public onDynamicPropsChange(newVal: any, oldVal: any) {
        if (newVal && !Util.isFieldsSame(newVal, oldVal)) {
            super.onDynamicPropsChange(newVal, oldVal);
        }
    }

    /**
     * 监听视图静态参数变化
     * 
     * @memberof AppGridView4Base
     */
    @Watch('staticProps', {
        immediate: true,
    })
    public onStaticPropsChange(newVal: any, oldVal: any) {
        if (newVal && !Util.isFieldsSame(newVal, oldVal)) {
            super.onStaticPropsChange(newVal, oldVal);
        }
    }

    /**
     * 渲染主表格
     *
     * @return {*} 
     * @memberof AppGridView4Base
     */
    renderMainGrid() {
        if (!this.gridInstance) {
            return null;
        }
        let { targetCtrlName, targetCtrlParam, targetCtrlEvent } = this.computeTargetCtrlData(this.gridInstance);
        //  默认单选，且选中第一条数据
        Object.assign(targetCtrlParam.staticProps, { isSingleSelect: true, isSelectFirstDefault: true });
        return this.$createElement(targetCtrlName, { slot: 'mainGrid', props: targetCtrlParam, ref: this.gridInstance?.name, on: targetCtrlEvent });
    }

    /**
     * 渲染主内容区
     *
     * @return {*}  {*}
     * @memberof AppGridView4Base
     */
    public renderMainContent(): any {
        if (!this.drTabInstance) {
            return null;
        }
        let { targetCtrlName, targetCtrlParam, targetCtrlEvent } = this.computeTargetCtrlData(this.drTabInstance);
        Object.assign(targetCtrlParam.staticProps, {
            isShowSlot: false
        })
        return this.$createElement(targetCtrlName, {
            slot: 'default',
            props: targetCtrlParam,
            ref: this.drTabInstance?.name,
            on: targetCtrlEvent,
        });
    }

    /**
     * 编辑视图渲染
     * 
     * @memberof AppGridView4Base
     */
    render(h: CreateElement) {
        if (!this.viewIsLoaded) {
            return null;
        }
        const targetViewLayoutComponent: any = AppLayoutService.getLayoutComponent(`${this.viewInstance.viewType}-${this.viewInstance.viewStyle}`);
        return h(targetViewLayoutComponent, {
            props: { viewInstance: this.viewInstance, model: this.model, modelService: this.modelService, viewparams: this.viewparams, context: this.context },
            scopedSlots: {
                quickSearchFilter: (content: any) => {
                    return this.renderDefaultQuickSearchFilter(content);
                }
            }
        }, [
            this.renderTopMessage(),
            this.renderToolBar(),
            this.renderQuickGroup(),
            this.renderQuickSearch(),
            this.renderQuickSearchForm(),
            this.renderMainGrid(),
            this.renderSearchForm(),
            this.renderSearchBar(),
            this.renderBodyMessage(),
            this.renderMainContent(),
            this.renderBottomMessage()
        ]);
    }

    /**
     * 销毁视图回调
     *
     * @memberof AppGridView4Base
     */
    public destroyed() {
        this.viewDestroyed();
    }

}