import { EntityProxyMiddleware } from '../../core';
import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { RawMaterialController } from './raw-material.controller';

export class RawMaterialMiddleware extends EntityProxyMiddleware {
  protected serviceTag = 'rawmaterial';
}

@Module({
  controllers: [RawMaterialController]
})
export class RawMaterialModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(RawMaterialMiddleware).forRoutes('(.*)/importdata', '(.*)/importtemplate', '(.*)/exportdata/(.*)');
  }
}

