import Vue from 'vue';
import { INotificationUtil, NotificationParams } from '@ibiz-template/runtime';
import { Notice } from 'view-design';

/**
 * 在界面右上角显示可关闭的全局通知
 *
 * @author chitanda
 * @date 2022-08-17 16:08:26
 * @export
 * @class NotificationUtil
 * @implements {INotificationUtil}
 */
export class NotificationUtil implements INotificationUtil {
  protected notice: Notice = Vue.prototype.$Notice;

  info(params: NotificationParams): void {
    this.notice.info(params);
  }

  success(params: NotificationParams): void {
    this.notice.success(params);
  }

  warning(params: NotificationParams): void {
    this.notice.warning(params);
  }

  error(params: NotificationParams): void {
    this.notice.error(params);
  }
}
